import plus
import random
from AI import vector3

import Arenas

class Hazard(object):
    def __init__(self, location):
        self.location = location


        
class Spikes(Hazard):
    
    def __init__(self, a_prismatic, a_power, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        #statuses: 0=waiting, 1=firing
        self.status = 0
        self.prismatic = a_prismatic
        self.power = a_power
        self.prismatic.SetAutoLock(False)
        self.timer = 0
        self.refcount = 0
        self.firesound = plus.createSound("Sounds\\hzd_spike_fire.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.firesound)
        
    def ZoneEvent(self, direction):
        if direction==1:
            self.timer = 0
            self.status = 1
            self.refcount += 1
        elif direction==-1:
            self.refcount -= 1
            if self.refcount == 0: self.status = 0
            
    def Tick(self):
        if self.status==1:
            self.timer += .5
            if self.timer == 1: self.FireTeeth()
            if self.timer == 2.5: self.timer = 0
            
    def FireTeeth(self):
        plus.playSound(self.firesound)
        self.prismatic.Lock(False)
        self.prismatic.ApplyForce(self.power)




        
class Saws(Hazard):

    def __init__(self, a_prismatic, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        #statuses: 0=off, 1=on
        self.status = 0
        self.prismatic = a_prismatic
        self.prismatic.SetAutoLock(False)
        self.prismatic.SetPowerSettings(2.0, -2000)
        self.timer = 0
        self.refcount = 0
        
    def ZoneEvent(self, direction):
        if direction==1:
            if self.refcount==0: self.MoveSaw(1)
            self.refcount += 1
        elif direction==-1:
            self.refcount -= 1
            if self.refcount==0: self.MoveSaw(-1)
            
    def MoveSaw(self, dir):
        self.prismatic.Lock(False)
        self.prismatic.SetDirection(dir)
        


        
class HellRaiser(Hazard):
    
    def __init__(self, a_hinge, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        #statuses: 0=waiting, 1=firing
        self.status = 0
        self.hinge = a_hinge
        self.hinge.SetAutoLocks(False, False)
        self.hinge.Lock(True)
        self.timer = 0
        self.soundHandle = plus.createSound("Sounds\\hellraiser_trigger.wav", 1, (0, 0, 0))
        
    def __del__(self):
        plus.removeSound(self.soundHandle)
        
    def Tick(self):
        self.timer += .5
        if (self.status == 1 and self.timer > 1):
            self.LowerHell()
                
    def RaiseHell(self):
        self.hinge.SetPowerSettings(80,1500)
        self.hinge.Lock(False)
        self.hinge.SetDirection(100)
        self.timer = 0
        self.status = 1
        plus.playSound(self.soundHandle)
        
    def LowerHell(self):
        self.hinge.SetPowerSettings(4, 200)
        self.hinge.Lock(False)
        self.hinge.SetDirection(-100)
        self.timer = 0
        self.status = 0
        
        
        
class PitSlider(Hazard):

    def __init__(self, a_prismatic, delay, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        self.slider = a_prismatic
        self.slider.SetPowerSettings(.2, 2000)
        self.slider.SetAutoLock(True)
        self.timer = 0
        self.slidetime = 0
        self.sliding = False
        self.delay = delay
        self.active = False
        self.slidesound = plus.createSound("Sounds\\hzd_trapfloor_loop.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.slidesound)
        
    def Tick(self):
        if self.active:
            self.timer += .5
            if self.timer == self.delay:
                self.slider.Lock(False)
                self.slider.SetDirection(1)
                self.active = False
                plus.loopSound(self.slidesound)
                self.sliding = True
                self.slidetime = 0
        
        if self.sliding:
            self.slidetime += .5
            if self.slidetime >= 16:
                plus.stopSound(self.slidesound)
            
    def setactive(self, state):
        self.active = state
        



class Hammer(Hazard):
    
    def __init__(self, a_hinge, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        #statuses: 0=waiting, 1=firing, 2=retracting to fire again, 3=retracting to shut down
        self.status = 0
        self.hinge = a_hinge
        self.hinge.SetAutoLocks(False, False)
        self.hinge.Lock(True)
        self.timer = 0
        self.refcount = 0
        self.firesound = plus.createSound("Sounds\\hzd_hammer_fire.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.firesound)
        
    def Tick(self):
        self.timer += .5
        if (self.status == 1 and self.timer > 1):
            self.Retract()
        if (self.status == 2 and self.timer > 2.5):
            self.Smash()
        if (self.status == 3 and self.timer > 3):
            self.Shutdown()
            
    def Smash(self):
        plus.playSound(self.firesound)
        self.hinge.SetPowerSettings(95,1200)
        self.hinge.Lock(False)
        self.hinge.SetDirection(100)
        self.timer = 0
        self.status = 1
        
    def Retract(self):
        self.hinge.SetPowerSettings(3, 300)
        self.hinge.Lock(False)
        self.hinge.SetDirection(-100)
        self.timer = 0
        self.status = 2
        
    def Shutdown(self):
        self.hinge.SetPowerSettings(0, 0)
        self.hinge.SetDirection(0)
        self.timer = 0
        self.status = 0
        
    def ZoneEvent(self, direction):
        if direction==1:
            if self.refcount==0: self.Smash()
            self.refcount += 1
        if direction==-1:
            self.refcount -= 1
            if self.refcount == 0:
                self.Retract()
                self.status = 3
                



class Smasher(Hazard):
    #used in Compressor Arena
    
    def __init__(self, a_hinge1, a_hinge2, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        #statuses: 0=waiting, 1=firing, 2=retracting to fire again, 3=retracting to shut down
        self.status = 0
        self.hinge1 = a_hinge1
        self.hinge1.SetAutoLocks(True, False)
        self.hinge1.Lock(True)
        self.hinge2 = a_hinge2
        self.hinge2.SetAutoLocks(True, False)
        self.hinge2.Lock(True)
        self.timer = 0
        self.refcount = 0
        self.Retract()
        self.status = 3
        self.firesound = plus.createSound("Sounds\\hzd_comp_fire.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.firesound)
        
    def Tick(self):
        self.timer += .5
        if (self.status == 1 and self.timer > 2):
            self.Retract()
        if (self.status == 2 and self.timer > 3):
            self.Smash()
        if (self.status == 3 and self.timer > 3):
            self.Shutdown()
            
    def Smash(self):
        plus.playSound(self.firesound)
        self.hinge1.SetPowerSettings(95, 15000)
        self.hinge1.Lock(False)
        self.hinge1.SetDirection(100)
        self.hinge2.SetPowerSettings(-95, 15000)
        self.hinge2.Lock(False)
        self.hinge2.SetDirection(100)
        self.timer = 0
        self.status = 1
        
    def Retract(self):
        self.hinge1.SetPowerSettings(12, 700)
        self.hinge1.Lock(False)
        self.hinge1.SetDirection(-100)
        self.hinge2.SetPowerSettings(-12, 700)
        self.hinge2.Lock(False)
        self.hinge2.SetDirection(-100)
        self.timer = 0
        self.status = 2
        
    def Shutdown(self):
        self.hinge1.SetPowerSettings(0, 0)
        self.hinge1.SetDirection(0)
        self.hinge2.SetPowerSettings(0, 0)
        self.hinge2.SetDirection(0)
        self.timer = 0
        self.status = 0
        
    def ZoneEvent(self, direction, robot):
        if direction==1:
            if self.refcount==0: self.Smash()
            self.refcount += 1
        if direction==-1:
            self.refcount -= 1
            if self.refcount == 0:
                self.Retract()
                self.status = 3




        
class TrapDoor(Hazard):

    def __init__(self, a_hinge, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        self.hinge = a_hinge
        self.hinge.Lock(True)
        self.ready = True
        self.firesound = plus.createSound("Sounds\\hzd_trapdoor.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.firesound)
        
    def Trigger(self):
        if self.ready:
            plus.playSound(self.firesound)
            self.hinge.Lock(False)
            self.hinge.SetDirection(100)
            self.hinge.ApplyTorque(300)
            self.ready = False
            return True
        else: return False
        






###########################################################################
###########################################################################
###########################################################################

################# MOVER #######################

class Mover_1(Hazard): 
    def __init__(self, a_prismatic, speed, location = (0, 0, 0)): # "speed" changed from "delay".
        Hazard.__init__(self, location)
        self.slider = a_prismatic
        self.slider.SetPowerSettings(2, 2000)
        self.slider.SetAutoLock(True)
        self.timer = 0
        self.slidetime = 0
        self.sliding = False
        self.Speed = speed # Added. (Used to be 'delay' from "_init_" above)
        self.activeON = False
        self.activeREV = False
        self.activeOFF = False
#        self.slidesound = plus.createSound("Sounds\\hzd_trapfloor_loop.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.slidesound)
        
    def Tick(self):
        if self.activeON == True:
            self.slider.SetPowerSettings(self.Speed, 2000)
            self.slider.Lock(False)
            self.slider.SetDirection(1)
#            plus.loopSound(self.slidesound)
            self.sliding = True
            self.slidetime = 0

        if self.activeREV == True:
            self.slider.SetPowerSettings(self.Speed, 2000)
            self.slider.Lock(False)
            self.slider.SetDirection(-1)
#            plus.loopSound(self.slidesound)
            self.sliding = True
            self.slidetime = 0

        if self.activeOFF == True:
            self.slider.Lock(True)
            self.slider.SetDirection(0)
            self.sliding = False
#            plus.stopSound(self.slidesound)
            self.active = False
            self.activeR = False
            
    def MoveON(self, stateON): # Input from Arena.py
        self.activeON = True
        self.activeREV = False
        self.activeOFF = False

    def MoveREV(self, stateREV):
        self.activeON = False
        self.activeREV = True
        self.activeOFF = False

    def MoveOFF(self, stateOFF):
        self.activeON = False
        self.activeREV = False
        self.activeOFF = True




################# POKER (retracts) #######################

class Poker(Hazard):
    def __init__(self, a_prismatic, a_power, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        #statuses: 0=waiting, 1=firing
        self.status = 0
        self.prismatic = a_prismatic
        self.power = a_power
        self.prismatic.SetAutoLock(False)
        self.FireTimer = 0
        self.firesound = plus.createSound("Sounds\\hzd_hammer_fire_quieter.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.firesound)
        
    def ZoneEvent(self, direction):
        if direction==1:
            self.FireTimer += 1

    def FirePoker(self):
        self.FireTimer += 1
            
    def Tick(self):
        if self.FireTimer == 1: # Fire.
            plus.playSound(self.firesound)
            self.prismatic.Lock(False)
            self.prismatic.ApplyForce(self.power)

        if self.FireTimer >= 2: # Return. 
            if self.FireTimer == 2:  
                self.prismatic.ApplyForce(-self.power) 
            if self.FireTimer == 3: 
                self.prismatic.Lock(True)

            if self.FireTimer == 4: 
                self.FireTimer = 0

            




    ############---FIRE SECTION---##################

class Flame(Hazard):  #---FLAME-------

    def __init__(self, location = (0, 0, 0), velocity = (0, 0, 0), variance = (0, 0, 0), yOffset = 0):
        Hazard.__init__(self, location)
        self.refcount = 0
        self.velocity = velocity
        self.variance = variance
        self.emitter = plus.AddParticleEmitter(self.location, self.velocity, self.variance)
        self.emitting = False
        self.timeEmitting = 0
        self.adjustedLoc = vector3(self.location)
        self.adjustedLoc.y += yOffset
        self.flamesound = plus.createSound("Sounds/flame_thrower.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.flamesound)
        
    def Tick(self):
        if self.emitting==True:
            if plus.isMatchOver():
                self.FlameOff()
                
            if self.timeEmitting<1:     
                self.timeEmitting += .25
            
            vel = vector3(self.velocity)
            flamepos = vel * self.timeEmitting
            flamepos = flamepos + vector3(self.location)
            arena = Arenas.currentArena
            if arena:
                compinfo = plus.rayTest(self.adjustedLoc.asTuple(), flamepos.asTuple())
                if not compinfo[0]==-1:  # we got a valid bot and component back from the ray test
                    if not plus.isMatchPaused() and not plus.isMatchOver():
                        plus.damage(compinfo[0], compinfo[1], 25, (compinfo[2], compinfo[3], compinfo[4]))
    
    def FlameOff(self):
        self.emitter.SetEmitting(False)
        self.emitting = False
        plus.stopSound(self.flamesound)
    
    def FlameOn(self):
        self.emitter.SetEmitting(True)
        self.emitting = True
        plus.loopSound(self.flamesound)
        self.timeEmitting = 0
    
    def ZoneEvent(self, direction):
        if direction==1:
            self.refcount+= 1
            if self.refcount == 1:
                self.FlameOn()
        elif direction==-1:
            self.refcount -= 1
            if self.refcount == 0:
                self.FlameOff()
                



class FlameNS(Hazard):  #---FLAME No Sound-------
    def __init__(self, location = (0, 0, 0), velocity = (0, 0, 0), variance = (0, 0, 0), yOffset = 0):
        Hazard.__init__(self, location)
        self.refcount = 0
        self.velocity = velocity
        self.variance = variance
        self.emitter = plus.AddParticleEmitter(self.location, self.velocity, self.variance)
        self.emitting = False
        self.timeEmitting = 0
        self.adjustedLoc = vector3(self.location)
        self.adjustedLoc.y += yOffset
        self.flamesound = plus.createSound("Sounds/flame_thrower.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.flamesound)
        
    def Tick(self):
        if self.emitting==True:
            if plus.isMatchOver():
                self.FlameNSOff()
                
            if self.timeEmitting<1:     #flames are long enough by the end of 1 second
                self.timeEmitting += .25
            
            vel = vector3(self.velocity)
            flamepos = vel * self.timeEmitting
            flamepos = flamepos + vector3(self.location)
            arena = Arenas.currentArena
            if arena:
                compinfo = plus.rayTest(self.adjustedLoc.asTuple(), flamepos.asTuple())
                if not compinfo[0]==-1:  # we got a valid bot and component back from the ray test
                    if not plus.isMatchPaused() and not plus.isMatchOver():
                        plus.damage(compinfo[0], compinfo[1], 25, (compinfo[2], compinfo[3], compinfo[4]))
    
    def FlameNSOff(self):
        self.emitter.SetEmitting(False)
        self.emitting = False
        plus.stopSound(self.flamesound)
    
    def FlameNSOn(self):
        self.emitter.SetEmitting(True)
        self.emitting = True
#        plus.loopSound(self.flamesound)
        self.timeEmitting = 0
    
    def ZoneEvent(self, direction):
        if direction==1:
            self.refcount+= 1
            if self.refcount == 1:
                self.FlameOn()
        elif direction==-1:
            self.refcount -= 1
            if self.refcount == 0:
                self.FlameOff()
                



class FlameND(Hazard):  #---FLAME No Damage-------
    def __init__(self, location = (0, 0, 0), velocity = (0, 0, 0), variance = (0, 0, 0), yOffset = 0):
        Hazard.__init__(self, location)
        self.refcount = 0
        self.velocity = velocity
        self.variance = variance
        self.emitter = plus.AddParticleEmitter(self.location, self.velocity, self.variance)
        self.emitting = False
        self.timeEmitting = 0
        self.adjustedLoc = vector3(self.location)
        self.adjustedLoc.y += yOffset
        self.flamesound = plus.createSound("Sounds/flame_thrower.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.flamesound)
        
    def Tick(self):
        if self.emitting==True:
            if plus.isMatchOver():
                self.FlameNDOff()
                
            if self.timeEmitting<1:     #flames are long enough by the end of 1 second
                self.timeEmitting += .25
            
            vel = vector3(self.velocity)
            flamepos = vel * self.timeEmitting
            flamepos = flamepos + vector3(self.location)
#            arena = Arenas.currentArena
#            if arena:
#                compinfo = plus.rayTest(self.adjustedLoc.asTuple(), flamepos.asTuple())
#                if not compinfo[0]==-1:  # we got a valid bot and component back from the ray test
#                    if not plus.isMatchPaused() and not plus.isMatchOver():
#                        plus.damage(compinfo[0], compinfo[1], 25, (compinfo[2], compinfo[3], compinfo[4]))
    
    def FlameNDOff(self):
        self.emitter.SetEmitting(False)
        self.emitting = False
        plus.stopSound(self.flamesound)
    
    def FlameNDOn(self):
        self.emitter.SetEmitting(True)
        self.emitting = True
        plus.loopSound(self.flamesound)
        self.timeEmitting = 0
    
    def ZoneEvent(self, direction):
        if direction==1:
            self.refcount+= 1
            if self.refcount == 1:
                self.FlameOn()
        elif direction==-1:
            self.refcount -= 1
            if self.refcount == 0:
                self.FlameOff()
                



class FlameNSND(Hazard):  #---FLAME No Sound or Damage-------
    def __init__(self, location = (0, 0, 0), velocity = (0, 0, 0), variance = (0, 0, 0), yOffset = 0):
        Hazard.__init__(self, location)
        self.refcount = 0
        self.velocity = velocity
        self.variance = variance
        self.emitter = plus.AddParticleEmitter(self.location, self.velocity, self.variance)
        self.emitting = False
        self.timeEmitting = 0
        self.adjustedLoc = vector3(self.location)
        self.adjustedLoc.y += yOffset
        self.flamesound = plus.createSound("Sounds/flame_thrower.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.flamesound)
        
    def Tick(self):
        if self.emitting==True:
            if plus.isMatchOver():
                self.FlameNSNDOff()
                
            if self.timeEmitting<1:     #flames are long enough by the end of 1 second
                self.timeEmitting += .25
            
            vel = vector3(self.velocity)
            flamepos = vel * self.timeEmitting
            flamepos = flamepos + vector3(self.location)
#            arena = Arenas.currentArena
#            if arena:
#                compinfo = plus.rayTest(self.adjustedLoc.asTuple(), flamepos.asTuple())
#                if not compinfo[0]==-1:  # we got a valid bot and component back from the ray test
#                    if not plus.isMatchPaused() and not plus.isMatchOver():
#                        plus.damage(compinfo[0], compinfo[1], 25, (compinfo[2], compinfo[3], compinfo[4]))
    
    def FlameNSNDOff(self):
        self.emitter.SetEmitting(False)
        self.emitting = False
        plus.stopSound(self.flamesound)
    
    def FlameNSNDOn(self):
        self.emitter.SetEmitting(True)
        self.emitting = True
#        plus.loopSound(self.flamesound)
        self.timeEmitting = 0
    
    def ZoneEvent(self, direction):
        if direction==1:
            self.refcount+= 1
            if self.refcount == 1:
                self.FlameOn()
        elif direction==-1:
            self.refcount -= 1
            if self.refcount == 0:
                self.FlameOff()
                





class BotFlame(Hazard):  # ---- BotFlame ----
    def __init__(self, location = (0, 0, 0), velocity = (0, 0, 0), variance = (0, 0, 0), yOffset = 0):
        Hazard.__init__(self, location)
        self.refcount = 0
        self.velocity = velocity
        self.variance = variance
        self.emitter = plus.AddParticleEmitter(self.location, self.velocity, self.variance)
        self.emitting = False
        self.timeEmitting = 0
        self.adjustedLoc = vector3(self.location)
        self.adjustedLoc.y += yOffset

    def __del__(self):
        plus.removeSound(self.flamesound)
        
    def Tick(self):
        if self.emitting==True:
            if plus.isMatchOver():
                self.FlameOff()
                
            if self.timeEmitting<1:     
                self.timeEmitting += .25
            
            vel = vector3(self.velocity)
            flamepos = vel * self.timeEmitting
            flamepos = flamepos + vector3(self.location)
    
    def BotFlameOff(self):
        self.emitter.SetEmitting(False)
        self.emitting = False
#        plus.stopSound(self.flamesound)
    
    def BotFlameOn(self):
        self.emitter.SetEmitting(True)
        self.emitting = True
        self.timeEmitting = 0

    



class KillerFlame(Hazard):  # ---- KILLER FLAME ----
    def __init__(self, location = (0, 0, 0), velocity = (0, 0, 0), variance = (0, 0, 0), yOffset = 0):
        Hazard.__init__(self, location)
        self.refcount = 0
        self.velocity = velocity
        self.variance = variance
        self.emitter = plus.AddParticleEmitter(self.location, self.velocity, self.variance)
        self.emitting = False
        self.timeEmitting = 0
        self.adjustedLoc = vector3(self.location)
        self.adjustedLoc.y += yOffset
        self.flamesound = plus.createSound("Sounds/flame_thrower.wav", True, self.location)
#        self.crackling = plus.createSound("Sounds/Crackling-short.wav", True, self.location) ########
        
    def __del__(self):
        plus.removeSound(self.flamesound)
#        plus.removeSound(self.crackling)
        
    def Tick(self):
        if self.emitting==True:
            if plus.isMatchOver():
                self.KillerFlameOff()
                
            if self.timeEmitting<1:     # Where damage happens vvvvvvv below vvvvvv.
                self.timeEmitting += .25
            
            vel = vector3(self.velocity)
            flamepos = vel * self.timeEmitting
            flamepos = flamepos + vector3(self.location)
            arena = Arenas.currentArena
            if arena:
                compinfo = plus.rayTest(self.adjustedLoc.asTuple(), flamepos.asTuple())
                if not compinfo[0]==-1:  # we got a valid bot and component back from the ray test
                    if not plus.isMatchPaused() and not plus.isMatchOver():
                        plus.damage(compinfo[0], compinfo[1], 2000, (compinfo[2], compinfo[3], compinfo[4]))
#                        plus.playSound(self.crackling) # none of these 3 work.
#                        plus.loopSound(self.crackling)
#                        plus.(self.crackling)


#    def CracklingSound(self):
#        plus.playSound(self.crackling)

    def KillerFlameOff(self):
        self.emitter.SetEmitting(False)
        self.emitting = False
        plus.stopSound(self.flamesound)
    
    def KillerFlameOn(self):
        self.emitter.SetEmitting(True)
        self.emitting = True
        plus.loopSound(self.flamesound)
        self.timeEmitting = 0
    
    def ZoneEvent(self, direction):
        if direction==1:
            self.refcount+= 1
            if self.refcount == 1:
                self.KillerFlameOn()
        elif direction==-1:
            self.refcount -= 1
            if self.refcount == 0:
                self.KillerFlameOff()
                



class KillerFlameNS(Hazard):  # ---- KILLER FLAME  No Sound ----
    def __init__(self, location = (0, 0, 0), velocity = (0, 0, 0), variance = (0, 0, 0), yOffset = 0):
        Hazard.__init__(self, location)
        self.refcount = 0
        self.velocity = velocity
        self.variance = variance
        self.emitter = plus.AddParticleEmitter(self.location, self.velocity, self.variance)
        self.emitting = False
        self.timeEmitting = 0
        self.adjustedLoc = vector3(self.location)
        self.adjustedLoc.y += yOffset
        self.flamesound = plus.createSound("Sounds/flame_thrower.wav", True, self.location)
#        self.crackling = plus.createSound("Sounds/Crackling-short.wav", True, self.location) ########
        
    def __del__(self):
        plus.removeSound(self.flamesound)
#        plus.removeSound(self.crackling)
        
    def Tick(self):
        if self.emitting==True:
            if plus.isMatchOver():
                self.KillerFlameNSOff()
                
            if self.timeEmitting<1:     # Where damage happens
                self.timeEmitting += .25
            
            vel = vector3(self.velocity)
            flamepos = vel * self.timeEmitting
            flamepos = flamepos + vector3(self.location)
            arena = Arenas.currentArena
            if arena:
                compinfo = plus.rayTest(self.adjustedLoc.asTuple(), flamepos.asTuple())
                if not compinfo[0]==-1:  # we got a valid bot and component back from the ray test
                    if not plus.isMatchPaused() and not plus.isMatchOver():
                        plus.damage(compinfo[0], compinfo[1], 2000, (compinfo[2], compinfo[3], compinfo[4]))

    def KillerFlameNSOff(self):
        self.emitter.SetEmitting(False)
        self.emitting = False
        plus.stopSound(self.flamesound)
    
    def KillerFlameNSOn(self):
        self.emitter.SetEmitting(True)
        self.emitting = True
#        plus.loopSound(self.flamesound)
        self.timeEmitting = 0
    
    def ZoneEvent(self, direction):
        if direction==1:
            self.refcount+= 1
            if self.refcount == 1:
                self.KillerFlameOn()
        elif direction==-1:
            self.refcount -= 1
            if self.refcount == 0:
                self.KillerFlameOff()




class KillerFlameX(Hazard):  # ---- KILLER FLAME X ----
    def __init__(self, location = (0, 0, 0), velocity = (0, 0, 0), variance = (0, 0, 0), yOffset = 0):
        Hazard.__init__(self, location)
        self.refcount = 0
        self.velocity = velocity
        self.variance = variance
        self.emitter = plus.AddParticleEmitter(self.location, self.velocity, self.variance)
        self.emitting = False
        self.timeEmitting = 0
        self.adjustedLoc = vector3(self.location)
        self.adjustedLoc.y += yOffset
        self.flamesound = plus.createSound("Sounds/flame_thrower.wav", True, self.location)
#        self.crackling = plus.createSound("Sounds/Crackling-short.wav", True, self.location) ########
        
    def __del__(self):
        plus.removeSound(self.flamesound)
#        plus.removeSound(self.crackling)
        
    def Tick(self):
        if self.emitting==True:
            if plus.isMatchOver():
                self.KillerFlameXOff()
                
            if self.timeEmitting<1:     # Where damage happens
                self.timeEmitting += .25
            
            vel = vector3(self.velocity)
            flamepos = vel * self.timeEmitting
            flamepos = flamepos + vector3(self.location)
            arena = Arenas.currentArena
            if arena:
                compinfo = plus.rayTest(self.adjustedLoc.asTuple(), flamepos.asTuple())
                if not compinfo[0]==-1:  # we got a valid bot and component back from the ray test
                    if not plus.isMatchPaused() and not plus.isMatchOver():
                        plus.damage(compinfo[0], compinfo[1], 100000000, (compinfo[2], compinfo[3], compinfo[4]))
#                        plus.playSound(self.crackling) # none of thes 3 work.
#                        plus.loopSound(self.crackling)
#                        plus.(self.crackling)


#    def CracklingSound(self):
#        plus.playSound(self.crackling)

    def KillerFlameXOff(self):
        self.emitter.SetEmitting(False)
        self.emitting = False
        plus.stopSound(self.flamesound)
    
    def KillerFlameXOn(self):
        self.emitter.SetEmitting(True)
        self.emitting = True
        plus.loopSound(self.flamesound)
        self.timeEmitting = 0
    
    def ZoneEvent(self, direction):
        if direction==1:
            self.refcount+= 1
            if self.refcount == 1:
                self.KillerFlameOn()
        elif direction==-1:
            self.refcount -= 1
            if self.refcount == 0:
                self.KillerFlameOff()
                







    #########---BlueRay (lightning) SECTION---############

class BlueRay(Hazard):
    def __init__(self, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        self.chargetimer = 0.0
        self.zaptimer = 0.0
        self.announcetimer = 12.0
        self.sensors = {}
        self.zapping = []
        self.zapsound = plus.createSound("Sounds/Crackling-short.wav", True, self.location)
        self.chargesound = plus.createSound("Sounds/ST-Phaser(short).wav", True, self.location)
        self.announcer = (plus.createSound("Sounds/ST-whats_the_matter.wav", True, self.location), plus.createSound("Sounds/ST-fascinating6(delay).wav", True, self.location), plus.createSound("Sounds/ST-cut_power.wav", True, self.location), plus.createSound("Sounds/ST-completed_analysis.wav", True, self.location), plus.createSound("Sounds/ST-blazes3.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location))
    
    def __del__(self):
        plus.removeSound(self.zapsound)
        plus.removeSound(self.chargesound)
        
        for x in self.announcer:
            plus.removeSound(x)
        
        self.announcer = ()

    def Tick(self):
        self.announcetimer -= .25
        if self.chargetimer==0.0 and self.NumBotsInRange()==1:
            self.Zap()
            
        if self.zaptimer>0.0:
            self.zaptimer-=.25
            if self.zaptimer<=0.0:
                self.zaptimer = 0.0
                self.zapping = []
                plus.stopSound(self.zapsound)
            elif self.zaptimer>0.0:
                for bot in self.zapping:
                    if not plus.isMatchPaused() and not plus.isMatchOver():
                        #plus.damage(bot, 0, 25, plus.getLocation(bot)) #(damage points taken/added).
                        plus.damage(bot, 0, 100, plus.getLocation(bot)) 
                        if self.sensors[bot]:
                            #plus.force(bot, 0, 115 * plus.getWeight(bot), 0) #  X, Y, Z axes are available here.
                            plus.force(bot, 0, 1000 * plus.getWeight(bot), 0) # 'Y'-VERTICAL impact.
#                            plus.force(bot, 1000 * plus.getWeight(bot), 0, 0) # 'X'-horizontal impact.
#                            plus.force(bot, 0, 0, 10000 * plus.getWeight(bot)) # 'Z'-horizontal impact.
            
        if self.chargetimer > 0.0:
            self.chargetimer -= .25
        elif self.chargetimer<0.0:
            self.chargetimer = 0.0

    def Zap(self):
        if not plus.isMatchPaused() and not plus.isMatchOver():
            if self.chargetimer==0.0:
                for bot, in_range in self.sensors.iteritems():
                    if in_range:
                        plus.zap(bot, 10, 3.0) # first number is how many lightnings on chassis.  Second number is how long lightnings spark on chassis.
                        self.zapping.append(bot)
                        self.zaptimer = 3.0
                        self.chargetimer = 5.0
#                        Arenas.currentArena.Charge(self.chargetimer, self.sensors)
                        Arenas.currentArena.ChargeA(self.chargetimer, self.sensors)
                        plus.loopSound(self.zapsound)
                        plus.playSound(self.chargesound)
                        if self.announcetimer <= 0:
                            plus.playSound(random.choice(self.announcer))
                            self.announcetimer = 12.0
        
    def Button(self):
        self.Zap()
        
    def NumBotsInRange(self):
        numBots = 0
        for bot, in_range in self.sensors.iteritems():
            if in_range: numBots += 1
                
        return numBots
        
    def ZoneEvent(self, direction, robot, chassis):
        if chassis:
            r = robot - 1
            if r not in self.sensors: self.sensors[r] = 0            

            if direction==1: self.sensors[r] += 1
            elif direction==-1: self.sensors[r] -= 1




class Recharger(Hazard):
    def __init__(self, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        self.chargetimer = 0.0
        self.zaptimer = 0.0
#        self.announcetimer = 12.0
        self.sensors = {}
        self.zapping = []
        self.zapsound = plus.createSound("Sounds/ST-ChargeUp-3-loop.wav", True, self.location)
        self.chargesound = plus.createSound("Sounds/ST-pure_energy2(delay).wav", True, self.location)
#        self.announcer = (plus.createSound("Sounds/ST-pure_energy2(delay).wav", True, self.location), plus.createSound("Sounds/ST-fascinating6(delay).wav", True, self.location), plus.createSound("Sounds/ST-cut_power.wav", True, self.location), plus.createSound("Sounds/ST-completed_analysis.wav", True, self.location), plus.createSound("Sounds/ST-blazes3.wav", True, self.location))
    
    def __del__(self):
        plus.removeSound(self.zapsound)
        plus.removeSound(self.chargesound)
        
#        for x in self.announcer:
#            plus.removeSound(x)
        
#        self.announcer = ()

    def Tick(self):
#        self.announcetimer -= .25
        if self.chargetimer==0.0 and self.NumBotsInRange()==1:
            self.Zap()
            
        if self.zaptimer>0.0:
            self.zaptimer-=.25 
            if self.zaptimer<=0.0:
                self.zaptimer = 0.0
                self.zapping = []
                plus.stopSound(self.zapsound)
            elif self.zaptimer>0.0:
                for bot in self.zapping:
                    if not plus.isMatchPaused() and not plus.isMatchOver():
                        #plus.damage(bot, 0, 25, plus.getLocation(bot)) #(damage points taken/added).
                        plus.damage(bot, 0, -100, plus.getLocation(bot))
                        if self.sensors[bot]:
                            #plus.force(bot, 0, 115 * plus.getWeight(bot), 0) #  X, Y, Z axes are available here.
                            plus.force(bot, 0, 10 * plus.getWeight(bot), 0)
            
        if self.chargetimer > 0.0:
            self.chargetimer -= .25
        elif self.chargetimer<0.0:
            self.chargetimer = 0.0

    def Zap(self):
        if not plus.isMatchPaused() and not plus.isMatchOver():
            if self.chargetimer==0.0:
                for bot, in_range in self.sensors.iteritems():
                    if in_range:
                        #plus.zap(bot, 10, 3.0)
                        plus.zap(bot, 800, 6.0)# first number is how many lightnings on chassis.  Second number is how long lightnings spark on chassis. 
                        self.zapping.append(bot)
                        self.zaptimer = 3.0
                        self.chargetimer = 5.0
#                        Arenas.currentArena.Charge(self.chargetimer, self.sensors)
                        Arenas.currentArena.ChargeB(self.chargetimer, self.sensors)
                        plus.playSound(self.zapsound)
#                        plus.loopSound(self.zapsound)
                        plus.playSound(self.chargesound)
#                        if self.announcetimer <= 0:
#                            plus.playSound(random.choice(self.announcer))
#                            self.announcetimer = 12.0
        

    def Button(self):
        self.Zap()
        
    def NumBotsInRange(self):
        numBots = 0
        for bot, in_range in self.sensors.iteritems():
            if in_range: numBots += 1
                
        return numBots
        
    def ZoneEvent(self, direction, robot, chassis):
        if chassis:
            p = robot - 1
            if p not in self.sensors: self.sensors[p] = 0
            
            if direction==1: self.sensors[p] += 1
            elif direction==-1: self.sensors[p] -= 1

#    def ZoneEvent(self, direction, robot, chassis):
#        if chassis:
#            r = robot - 1
#            if r not in self.sensors: self.sensors[r] = 0
#            
#            if direction==1: self.sensors[r] += 1
#            elif direction==-1: self.sensors[r] -= 1











########################################################################################################################
#################################################### UNDER CONSTRUCTION #################################################
########################################################################################################################

class Transporter(Hazard): # Under construction..............THIS SECTION IS NOT YET WORKING (still under constructon).
    def __init__(self, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        self.chargetimer = 0.0
        self.zaptimer = 0.0
        self.announcetimer = 12.0
        self.sensors = {}
        self.zapping = []
        self.zapsound = plus.createSound("Sounds/Crackling-short.wav", True, self.location)
        self.chargesound = plus.createSound("Sounds/ST-Phaser(short).wav", True, self.location)
        self.announcer = (plus.createSound("Sounds/ST-pure_energy2(delay).wav", True, self.location), plus.createSound("Sounds/ST-fascinating6(delay).wav", True, self.location), plus.createSound("Sounds/ST-cut_power.wav", True, self.location), plus.createSound("Sounds/ST-completed_analysis.wav", True, self.location), plus.createSound("Sounds/ST-blazes3.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location), plus.createSound("Sounds/BLANK.wav", True, self.location))
    
    def __del__(self):
        plus.removeSound(self.zapsound)
        plus.removeSound(self.chargesound)
        
        for x in self.announcer:
            plus.removeSound(x)
        
        self.announcer = ()

    def Tick(self):
        self.announcetimer -= .25
        if self.chargetimer==0.0 and self.NumBotsInRange()==1:
            self.Zap()
            
        if self.zaptimer>0.0:
            self.zaptimer-=.25
            if self.zaptimer<=0.0:
                self.zaptimer = 0.0
                self.zapping = []
                plus.stopSound(self.zapsound)
            elif self.zaptimer>0.0:
                for bot in self.zapping:
                    if not plus.isMatchPaused() and not plus.isMatchOver():
                        #plus.damage(bot, 0, 25, plus.getLocation(bot))
                        plus.damage(bot, 0, -10, plus.getLocation(bot))# 10 points added (negative damage); (damage points taken/added).
                        if self.sensors[bot]:
#                            plus.force(bot, 0, 115 * plus.getWeight(bot), 0) #  X, Y, Z axes are available here.
                            plus.force(bot, 0, 10000 * plus.getWeight(bot), 0) # 'Y'-VERTICAL impact.
#                            plus.force(bot, 10000 * plus.getWeight(bot), 0, 0) # 'X'-horizontal impact.
#                            plus.force(bot, 0, 0, 10000 * plus.getWeight(bot)) # 'Z'-horizontal impact.
            
        if self.chargetimer > 0.0:
            self.chargetimer -= .25
        elif self.chargetimer<0.0:
            self.chargetimer = 0.0

    def Zap(self):
        if not plus.isMatchPaused() and not plus.isMatchOver():
            if self.chargetimer==0.0:
                for bot, in_range in self.sensors.iteritems():
                    if in_range:
                        #plus.zap(bot, 10, 3.0)
                        plus.zap(bot, 1000, 6.0)# first number is how many lightnings on chassis.  Second number is how long lightning spark on chassis. 
                        self.zapping.append(bot)
                        self.zaptimer = 3.0
                        self.chargetimer = 5.0
                        Arenas.currentArena.Charge(self.chargetimer, self.sensors)
                        plus.loopSound(self.zapsound)
                        plus.playSound(self.chargesound)
                        if self.announcetimer <= 0:
                            plus.playSound(random.choice(self.announcer))
                            self.announcetimer = 12.0
        
    def Button(self):
        self.Zap()
        
    def NumBotsInRange(self):
        numBots = 0
        for bot, in_range in self.sensors.iteritems():
            if in_range: numBots += 1
                
        return numBots
        
    def ZoneEvent(self, direction, robot, chassis):
        if chassis:
            r = robot - 1
            if r not in self.sensors: self.sensors[r] = 0
            
            if direction==1:
                self.sensors[r] += 1
            elif direction==-1:
                self.sensors[r] -= 1






class BurstFlame(Hazard):  # ---- BurstFlame ---- THIS SECTION IS NOT YET WORKING (still under constructon).
    def __init__(self, location = (0, 0, 0), velocity = (0, 0, 0), variance = (0, 0, 0), yOffset = 0):
        Hazard.__init__(self, location)
        self.refcount = 0
        self.velocity = velocity
        self.variance = variance
        self.emitter = plus.AddParticleEmitter(self.location, self.velocity, self.variance)
        self.emitting = False

        self.adjustedLoc = vector3(self.location)
        self.adjustedLoc.y += yOffset

    def __del__(self):
        plus.removeSound(self.flamesound)
        
    def Tick(self):
        if self.emitting==True:
            if plus.isMatchOver():
                self.FlameOff()
                
        if self.emitting==False:
            self.FlameOff()
    
    def BurstFlameOff(self):
        self.emitter.SetEmitting(False)
        self.emitting = False
#        self.FlameOff()  # ADDED####
    
    def BurstFlameOn(self):
        self.emitter.SetEmitting(True)
        self.emitting = True
        self.timeEmitting = 0





class ParticleEmitter(Hazard): # Under construction..............THIS SECTION IS NOT YET WORKING (still under constructon).
    def __init__(self, location = (0, 0, 0), velocity = (0, 0, 0), variance = (0, 0, 0), yOffset = 0):
        Hazard.__init__(self, location)
        self.refcount = 0
        self.velocity = velocity
        self.variance = variance
        self.emitter = plus.AddParticleEmitter(self.location, self.velocity, self.variance)
        self.emitting = False
        self.timeEmitting = 0
        self.adjustedLoc = vector3(self.location)
        self.adjustedLoc.y += yOffset
        self.flamesound = plus.createSound("Sounds/flame_thrower.wav", True, self.location)
        self.crackling = plus.createSound("Sounds/Crackling-short.wav", True, self.location) ########
        
    def __del__(self):
        plus.removeSound(self.flamesound)
        
    def Tick(self):
        if self.emitting==True:
            if plus.isMatchOver():
                self.ParticleEmitterOff()
                
            if self.timeEmitting<1:     # Where damage happens
                self.timeEmitting += .25
            
            vel = vector3(self.velocity)
            flamepos = vel * self.timeEmitting
            flamepos = flamepos + vector3(self.location)
            arena = Arenas.currentArena
            if arena:
                compinfo = plus.rayTest(self.adjustedLoc.asTuple(), flamepos.asTuple())
                if not compinfo[0]==-1:  # we got a valid bot and component back from the ray test
                    if not plus.isMatchPaused() and not plus.isMatchOver():
                        plus.damage(compinfo[0], compinfo[1], 100000000000, (compinfo[2], compinfo[3], compinfo[4]))


    def ParticleEmitterOff(self):
        self.emitter.SetEmitting(False)
        self.emitting = False
        plus.stopSound(self.flamesound)
    
    def ParticleEmitterOn(self):
        self.emitter.SetEmitting(True)
        self.emitting = True
        plus.loopSound(self.flamesound)
        self.timeEmitting = 0
    
    def ZoneEvent(self, direction):
        if direction==1:
            self.refcount+= 1
            if self.refcount == 1:
                self.KillerFlameOn()
        elif direction==-1:
            self.refcount -= 1
            if self.refcount == 0:
                self.KillerFlameOff()
                
